
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of potassium
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1") # grams of fiber
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x2") # milligrams of vitamin D
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin B12


# Set objective function
m.setObjective(3.17 * x0 + 2.34 * x1 + 2.79 * x2 + 1.75 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * x0 + 1 * x1 >= 61)
m.addConstr(1 * x1 + 15 * x2 >= 98)
m.addConstr(15 * x2 + 17 * x3 >= 101)
m.addConstr(9 * x0 + 15 * x2 >= 112)
m.addConstr(9 * x0 + 1 * x1 + 15 * x2 >= 81)
m.addConstr(1 * x1 + 15 * x2 + 17 * x3 >= 81)
m.addConstr(9 * x0 + 1 * x1 + 17 * x3 >= 81)
m.addConstr(9 * x0 + 1 * x1 + 15 * x2 >= 85)
m.addConstr(1 * x1 + 15 * x2 + 17 * x3 >= 85)
m.addConstr(9 * x0 + 1 * x1 + 17 * x3 >= 85)
m.addConstr(9 * x0 + 1 * x1 + 15 * x2 >= 61)
m.addConstr(1 * x1 + 15 * x2 + 17 * x3 >= 61)
m.addConstr(9 * x0 + 1 * x1 + 17 * x3 >= 61)
m.addConstr(9 * x0 + 1 * x1 + 15 * x2 + 17 * x3 >= 61)
m.addConstr(4 * x0 + 6 * x1 + 10 * x2 + 1 * x3 >= 61)
m.addConstr(2 * x2 + 3 * x3 >= 44)
m.addConstr(16 * x0 + 2 * x2 >= 35)
m.addConstr(7 * x1 + 2 * x2 + 3 * x3 >= 40)
m.addConstr(16 * x0 + 7 * x1 + 2 * x2 + 3 * x3 >= 40)
m.addConstr(2 * x0 - 5 * x3 >= 0)
m.addConstr(-5 * x0 + 5 * x2 >= 0)
m.addConstr(-5 * x0 + 5 * x1 >= 0)
m.addConstr(4 * x0 + 6 * x1 <= 244)
m.addConstr(4 * x0 + 1 * x3 <= 383)
m.addConstr(6 * x1 + 1 * x3 <= 373)
m.addConstr(4 * x0 + 10 * x2 + 1 * x3 <= 113)
m.addConstr(4 * x0 + 6 * x1 + 1 * x3 <= 142)
m.addConstr(7 * x1 + 3 * x3 <= 220)
m.addConstr(16 * x0 + 3 * x3 <= 124)
m.addConstr(16 * x0 + 7 * x1 + 2 * x2 <= 229)

# Resource Constraints
m.addConstr(9*x0 + x1 + 15*x2 + 17*x3 <= 478)
m.addConstr(4*x0 + 6*x1 + 10*x2 + x3 <= 417)
m.addConstr(16*x0 + 7*x1 + 2*x2 + 3*x3 <= 255)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

