
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")
    x1 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, integrality=1, name="x1")
    x2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, integrality=1, name="x2")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")

    # Define objective function
    model.setObjective(3.17*x0 + 2.34*x1 + 2.79*x2 + 1.75*x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9*x0 <= 478)
    model.addConstr(4*x0 <= 417)
    model.addConstr(16*x0 <= 255)
    model.addConstr(x1 <= 478)
    model.addConstr(6*x1 <= 417)
    model.addConstr(7*x1 <= 255)
    model.addConstr(15*x2 <= 478)
    model.addConstr(10*x2 <= 417)
    model.addConstr(2*x2 <= 255)
    model.addConstr(17*x3 <= 478)
    model.addConstr(x3 <= 417)
    model.addConstr(3*x3 <= 255)
    model.addConstr(9*x0 + x1 >= 61)
    model.addConstr(x1 + 15*x2 >= 98)
    model.addConstr(15*x2 + 17*x3 >= 101)
    model.addConstr(9*x0 + 15*x2 >= 112)
    model.addConstr(9*x0 + x1 + 15*x2 >= 81)
    model.addConstr(x1 + 15*x2 + 17*x3 >= 81)
    model.addConstr(9*x0 + x1 + 17*x3 >= 81)
    model.addConstr(9*x0 + x1 + 15*x2 >= 85)
    model.addConstr(x1 + 15*x2 + 17*x3 >= 85)
    model.addConstr(9*x0 + x1 + 17*x3 >= 85)
    model.addConstr(9*x0 + x1 + 15*x2 >= 61)
    model.addConstr(x1 + 15*x2 + 17*x3 >= 61)
    model.addConstr(9*x0 + x1 + 17*x3 >= 61)
    model.addConstr(9*x0 + x1 + 15*x2 + 17*x3 >= 61)
    model.addConstr(4*x0 + 6*x1 + 10*x2 + x3 >= 61)
    model.addConstr(2*x2 + 3*x3 >= 44)
    model.addConstr(16*x0 + 2*x2 >= 35)
    model.addConstr(7*x1 + 2*x2 + 3*x3 >= 40)
    model.addConstr(16*x0 + 7*x1 + 2*x2 + 3*x3 >= 40)
    model.addConstr(2*x0 - 5*x3 >= 0)
    model.addConstr(-5*x0 + 5*x2 >= 0)
    model.addConstr(-5*x0 + 5*x1 >= 0)
    model.addConstr(4*x0 + 6*x1 <= 244)
    model.addConstr(4*x0 + x3 <= 383)
    model.addConstr(6*x1 + x3 <= 373)
    model.addConstr(4*x0 + 10*x2 + x3 <= 113)
    model.addConstr(4*x0 + 6*x1 + x3 <= 142)
    model.addConstr(7*x1 + 3*x3 <= 220)
    model.addConstr(16*x0 + 3*x3 <= 124)
    model.addConstr(16*x0 + 7*x1 + 2*x2 <= 229)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {x0.varValue}")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
