
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
hot_dogs = m.addVar(vtype=GRB.INTEGER, name="hot_dogs")
blueberry_pies = m.addVar(vtype=GRB.CONTINUOUS, name="blueberry_pies")
milkshakes = m.addVar(vtype=GRB.CONTINUOUS, name="milkshakes")
bowls_of_cereal = m.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")

# Set objective function
m.setObjective(8*hot_dogs + 7*blueberry_pies + 8*milkshakes + 3*bowls_of_cereal, GRB.MINIMIZE)

# Add constraints
m.addConstr(17*blueberry_pies + 23*milkshakes >= 73)
m.addConstr(22*hot_dogs + 23*milkshakes >= 107)
m.addConstr(22*hot_dogs + 17*blueberry_pies + 23*milkshakes + 11*bowls_of_cereal >= 107)
m.addConstr(4*hot_dogs + 14*milkshakes >= 45)
m.addConstr(14*milkshakes + 13*bowls_of_cereal >= 28)
m.addConstr(19*blueberry_pies + 14*milkshakes >= 27)
m.addConstr(4*hot_dogs + 19*blueberry_pies >= 67)
m.addConstr(4*hot_dogs + 13*bowls_of_cereal >= 43)
m.addConstr(4*hot_dogs + 19*blueberry_pies + 14*milkshakes + 13*bowls_of_cereal >= 43)
m.addConstr(-8*hot_dogs + 8*bowls_of_cereal >= 0)
m.addConstr(blueberry_pies - 10*milkshakes >= 0)
m.addConstr(22*hot_dogs + 11*bowls_of_cereal <= 143)
m.addConstr(22*hot_dogs + 23*milkshakes <= 247)
m.addConstr(22*hot_dogs + 17*blueberry_pies + 11*bowls_of_cereal <= 222)
m.addConstr(22*hot_dogs + 23*milkshakes + 11*bowls_of_cereal <= 138)
m.addConstr(22*hot_dogs + 17*blueberry_pies + 23*milkshakes <= 166)
m.addConstr(14*milkshakes + 13*bowls_of_cereal <= 187)


m.addConstr(22*hot_dogs + 4*hot_dogs <= 435) #protein from hotdogs
m.addConstr(19*blueberry_pies + 14*milkshakes + 13*bowls_of_cereal <= 315) # calcium


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

