
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["network_admins", "intrusion_analysts", "bandwidth", "patches", "soc_operators"])


# Set objective function
m.setObjective(7.63 * x[0] + 7.32 * x[1] + 7.5 * x[2] + 3.2 * x[3] + 1.63 * x[4], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * x[0] + 7 * x[1] + 9 * x[2] + 9 * x[3] + 11 * x[4] <= 104, "r0")
m.addConstr(2 * x[0] + 8 * x[1] + 11 * x[2] + 10 * x[3] + 2 * x[4] <= 114, "r1")
m.addConstr(7 * x[1] + 11 * x[4] >= 14, "c1")
m.addConstr(8 * x[1] + 10 * x[3] >= 11, "c2")
m.addConstr(2 * x[0] + 8 * x[1] >= 16, "c3")
m.addConstr(8 * x[1] + 2 * x[4] >= 9, "c4")
m.addConstr(11 * x[2] + 10 * x[3] >= 20, "c5")
m.addConstr(2 * x[0] + 8 * x[1] + 11 * x[2] >= 20, "c6")
m.addConstr(8 * x[1] + 11 * x[2] + 2 * x[4] >= 20, "c7")
m.addConstr(2 * x[0] + 10 * x[3] + 2 * x[4] >= 20, "c8")
m.addConstr(2 * x[0] + 8 * x[1] + 11 * x[2] >= 11, "c9")
m.addConstr(8 * x[1] + 11 * x[2] + 2 * x[4] >= 11, "c10")
m.addConstr(2 * x[0] + 10 * x[3] + 2 * x[4] >= 11, "c11")
m.addConstr(2 * x[0] + 8 * x[1] + 11 * x[2] >= 12, "c12")
m.addConstr(8 * x[1] + 11 * x[2] + 2 * x[4] >= 12, "c13")
m.addConstr(2 * x[0] + 10 * x[3] + 2 * x[4] >= 12, "c14")
m.addConstr(-9 * x[0] + 9 * x[1] + 10 * x[3] >= 0, "c15")
m.addConstr(9 * x[2] + 9 * x[3] <= 85, "c16")
m.addConstr(10 * x[0] + 9 * x[3] <= 92, "c17")
m.addConstr(7 * x[1] + 9 * x[2] + 9 * x[3] <= 36, "c18")
m.addConstr(10 * x[0] + 7 * x[1] + 9 * x[3] <= 54, "c19")
m.addConstr(10 * x[0] + 7 * x[1] + 9 * x[2] + 9 * x[3] + 11 * x[4] <= 54, "c20")
m.addConstr(8 * x[1] + 10 * x[3] <= 69, "c21")
m.addConstr(2 * x[0] + 8 * x[1] <= 70, "c22")
m.addConstr(2 * x[0] + 2 * x[4] <= 81, "c23")
m.addConstr(8 * x[1] + 11 * x[2] <= 39, "c24")
m.addConstr(2 * x[0] + 8 * x[1] + 11 * x[2] <= 44, "c25")
m.addConstr(11 * x[2] + 10 * x[3] + 2 * x[4] <= 27, "c26")
m.addConstr(2 * x[0] + 10 * x[3] + 2 * x[4] <= 108, "c27")
m.addConstr(2 * x[0] + 11 * x[2] + 2 * x[4] <= 56, "c28")
m.addConstr(8 * x[1] + 11 * x[2] + 10 * x[3] <= 70, "c29")
m.addConstr(2 * x[0] + 11 * x[2] + 10 * x[3] <= 105, "c30")
m.addConstr(2 * x[0] + 8 * x[1] + 11 * x[2] + 10 * x[3] + 2 * x[4] <= 105, "c31")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Objective Value: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

