
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Bobby
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="x1")  # hours worked by Peggy
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by George
    x3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")  # hours worked by Laura


    # Set objective function
    model.setObjective(5.26 * x0 + 4.69 * x1 + 6.55 * x2 + 5.86 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * x1 + 14 * x2 >= 10)
    model.addConstr(2 * x0 + 14 * x2 + 8 * x3 >= 21)
    model.addConstr(9 * x1 + 14 * x2 + 8 * x3 >= 21)
    model.addConstr(2 * x0 + 14 * x2 + 8 * x3 >= 13)
    model.addConstr(9 * x1 + 14 * x2 + 8 * x3 >= 13)
    model.addConstr(2 * x0 + 9 * x1 + 14 * x2 + 8 * x3 >= 13)
    model.addConstr(12 * x1 + 7 * x3 >= 10)
    model.addConstr(11 * x0 + 3 * x2 >= 15)
    model.addConstr(11 * x0 + 12 * x1 >= 7)
    model.addConstr(12 * x1 + 3 * x2 + 7 * x3 >= 14)
    model.addConstr(11 * x0 + 12 * x1 + 7 * x3 >= 14)
    model.addConstr(12 * x1 + 3 * x2 + 7 * x3 >= 16)
    model.addConstr(11 * x0 + 12 * x1 + 7 * x3 >= 16)
    model.addConstr(11 * x0 + 12 * x1 + 3 * x2 + 7 * x3 >= 16)
    model.addConstr(-2 * x2 + 9 * x3 >= 0)
    model.addConstr(6 * x0 - 8 * x1 >= 0)
    model.addConstr(9 * x1 + 14 * x2 <= 77)
    model.addConstr(14 * x2 + 8 * x3 <= 34)
    model.addConstr(2 * x0 + 9 * x1 <= 25)
    model.addConstr(11 * x0 + 3 * x2 + 7 * x3 <= 26)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
