
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', lb=0)  # hours worked by Bobby
    x1 = model.addVar(name='x1', lb=0, integrality=1)  # hours worked by Peggy
    x2 = model.addVar(name='x2', lb=0)  # hours worked by George
    x3 = model.addVar(name='x3', lb=0)  # hours worked by Laura

    # Objective function
    model.setObjective(5.26*x0 + 4.69*x1 + 6.55*x2 + 5.86*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x1 + 14*x2 + 8*x3 >= 10)
    model.addConstr(2*x0 + 14*x2 + 8*x3 >= 21)
    model.addConstr(9*x1 + 14*x2 + 8*x3 >= 21)
    model.addConstr(2*x0 + 14*x2 + 8*x3 >= 13)
    model.addConstr(9*x1 + 14*x2 + 8*x3 >= 13)
    model.addConstr(2*x0 + 9*x1 + 14*x2 + 8*x3 >= 13)
    model.addConstr(12*x1 + 7*x3 >= 10)
    model.addConstr(11*x0 + 3*x2 >= 15)
    model.addConstr(11*x0 + 12*x1 >= 7)
    model.addConstr(12*x1 + 3*x2 + 7*x3 >= 14)
    model.addConstr(11*x0 + 12*x1 + 7*x3 >= 14)
    model.addConstr(12*x1 + 3*x2 + 7*x3 >= 16)
    model.addConstr(11*x0 + 12*x1 + 7*x3 >= 16)
    model.addConstr(11*x0 + 12*x1 + 3*x2 + 7*x3 >= 16)
    model.addConstr(-2*x2 + 9*x3 >= 0)
    model.addConstr(6*x0 - 8*x1 >= 0)
    model.addConstr(9*x1 + 14*x2 <= 77)
    model.addConstr(14*x2 + 8*x3 <= 34)
    model.addConstr(2*x0 + 9*x1 <= 25)
    model.addConstr(11*x0 + 3*x2 + 7*x3 <= 26)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Bobby: ', x0.varValue)
        print('Hours worked by Peggy: ', x1.varValue)
        print('Hours worked by George: ', x2.varValue)
        print('Hours worked by Laura: ', x3.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
