
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="George")
paul = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Paul")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura")
ringo = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Ringo")
hank = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Hank")


# Set objective function
m.setObjective(8.72 * george + 6.37 * paul + 8.49 * laura + 2.59 * ringo + 1.75 * hank, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * george + 8 * paul >= 34)
m.addConstr(5 * george + 1 * hank >= 50)
m.addConstr(5 * george + 6 * ringo >= 64)
m.addConstr(6 * ringo + 1 * hank >= 72)
m.addConstr(8 * paul + 6 * ringo >= 59)
m.addConstr(5 * george + 8 * paul + 1 * hank >= 52)
m.addConstr(5 * george + 8 * paul + 11 * laura + 6 * ringo + 1 * hank >= 52)
m.addConstr(4 * laura + 14 * hank >= 81)
m.addConstr(10 * george + 4 * laura >= 82)
m.addConstr(10 * george + 6 * paul >= 78)
m.addConstr(7 * ringo + 14 * hank >= 84)
m.addConstr(6 * paul + 4 * laura >= 75)
m.addConstr(10 * george + 6 * paul + 4 * laura + 7 * ringo + 14 * hank >= 75)
m.addConstr(17 * laura + 6 * ringo >= 21)
m.addConstr(3 * george + 2 * paul >= 20)
m.addConstr(3 * george + 12 * hank >= 11)
m.addConstr(17 * laura + 6 * ringo + 12 * hank >= 28)
m.addConstr(3 * george + 2 * paul + 17 * laura + 6 * ringo + 12 * hank >= 28)
m.addConstr(-10 * george + 6 * laura >= 0)
m.addConstr(-5 * paul + 3 * hank >= 0)
m.addConstr(8 * paul + 11 * laura <= 117)
m.addConstr(5 * george + 6 * ringo <= 272)
m.addConstr(8 * paul + 6 * ringo <= 232)
m.addConstr(11 * laura + 6 * ringo <= 371)
m.addConstr(8 * paul + 1 * hank <= 369)
m.addConstr(5 * george + 11 * laura + 1 * hank <= 196)
m.addConstr(5 * george + 11 * laura + 6 * ringo <= 334)
m.addConstr(6 * paul + 4 * laura <= 284)
m.addConstr(4 * laura + 7 * ringo <= 218)
m.addConstr(10 * george + 14 * hank <= 102)
m.addConstr(10 * george + 6 * paul <= 135)
m.addConstr(10 * george + 4 * laura <= 264)
m.addConstr(10 * george + 7 * ringo <= 280)
m.addConstr(10 * george + 6 * paul + 4 * laura <= 278)
m.addConstr(10 * george + 4 * laura + 14 * hank <= 318)
m.addConstr(6 * paul + 4 * laura + 14 * hank <= 364)
m.addConstr(2 * paul + 17 * laura <= 50)
m.addConstr(3 * george + 6 * ringo <= 98)
m.addConstr(2 * paul + 12 * hank <= 83)
m.addConstr(6 * ringo + 12 * hank <= 51)
m.addConstr(2 * paul + 6 * ringo <= 102)
m.addConstr(2 * paul + 17 * laura + 12 * hank <= 67)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

