
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["chicken thighs", "bagged salads", "apples", "knishes", "slices of pizza"])

    # Set objective function
    m.setObjective(7*x[0] + 5*x[1] + 5*x[2] + 9*x[3] + 3*x[4], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*x[1] + 16*x[3] >= 28, "c1")
    m.addConstr(2*x[0] + 15*x[2] >= 37, "c2")
    m.addConstr(15*x[2] + 16*x[3] >= 33, "c3")
    m.addConstr(2*x[0] + 7*x[4] >= 37, "c4")
    m.addConstr(16*x[3] + 7*x[4] >= 21, "c5")
    m.addConstr(2*x[1] + 15*x[2] >= 39, "c6")
    m.addConstr(2*x[0] + 16*x[3] + 7*x[4] >= 29, "c7")
    m.addConstr(2*x[0] + 2*x[1] + 15*x[2] + 16*x[3] + 7*x[4] >= 29, "c8")
    m.addConstr(2*x[3] - 10*x[4] >= 0, "c9")
    m.addConstr(15*x[2] + 16*x[3] <= 64, "c10")
    m.addConstr(2*x[1] + 15*x[2] + 16*x[3] <= 196, "c11")
    m.addConstr(2*x[0] + 2*x[1] + 7*x[4] <= 153, "c12")
    m.addConstr(2*x[0] + 2*x[1] + 15*x[2] <= 86, "c13")
    m.addConstr(2*x[0] + 2*x[1] + 15*x[2] + 16*x[3] + 7*x[4] <= 207, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
