
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="chicken_thighs", lb=0)  # chicken thighs
x2 = m.addVar(name="bagged_salads", lb=0)  # bagged salads
x3 = m.addVar(name="apples", lb=0)  # apples
x4 = m.addVar(name="knishes", lb=0)  # knishes
x5 = m.addVar(name="slices_of_pizza", lb=0)  # slices of pizza

# Objective function
m.setObjective(7 * x1 + 5 * x2 + 5 * x3 + 9 * x4 + 3 * x5, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(2 * x1 + 2 * x2 + 15 * x3 + 16 * x4 + 7 * x5 <= 207, name="calcium_upper_bound")
m.addConstr(2 * x2 + 16 * x4 >= 28, name="calcium_from_bagged_salads_and_knishes")
m.addConstr(2 * x1 + 15 * x3 >= 37, name="calcium_from_chicken_thighs_and_apples")
m.addConstr(15 * x3 + 16 * x4 >= 33, name="calcium_from_apples_and_knishes")
m.addConstr(2 * x1 + 7 * x5 >= 37, name="calcium_from_chicken_thighs_and_slices_of_pizza")
m.addConstr(16 * x4 + 7 * x5 >= 21, name="calcium_from_knishes_and_slices_of_pizza")
m.addConstr(2 * x2 + 15 * x3 >= 39, name="calcium_from_bagged_salads_and_apples")
m.addConstr(2 * x1 + 16 * x4 + 7 * x5 >= 29, name="calcium_from_chicken_thighs_knishes_and_slices_of_pizza")
m.addConstr(2 * x1 + 2 * x2 + 15 * x3 + 16 * x4 + 7 * x5 >= 29, name="calcium_from_all_sources")
m.addConstr(2 * x4 - 10 * x5 >= 0, name="knishes_and_slices_of_pizza_relationship")
m.addConstr(15 * x3 + 16 * x4 <= 64, name="calcium_from_apples_and_knishes_upper_bound")
m.addConstr(2 * x2 + 15 * x3 + 16 * x4 <= 196, name="calcium_from_bagged_salads_apples_and_knishes_upper_bound")
m.addConstr(2 * x1 + 2 * x2 + 7 * x5 <= 153, name="calcium_from_chicken_thighs_bagged_salads_and_slices_of_pizza_upper_bound")
m.addConstr(2 * x1 + 2 * x2 + 15 * x3 <= 86, name="calcium_from_chicken_thighs_bagged_salads_and_apples_upper_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken Thighs: ", x1.varValue)
    print("Bagged Salads: ", x2.varValue)
    print("Apples: ", x3.varValue)
    print("Knishes: ", x4.varValue)
    print("Slices of Pizza: ", x5.varValue)
else:
    print("The model is infeasible")
