
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")
    x1 = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")
    x2 = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")
    x3 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")


    # Set objective function
    m.setObjective(2*x0**2 + 6*x0*x1 + 3*x0*x2 + 4*x1**2 + 8*x1*x3 + 6*x2**2 + 8*x2*x3 + 4*x1 + 6*x2 + 9*x3, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*x0 + 26*x1 + 3*x2 + 22*x3 <= 136, "c0")
    m.addConstr(11*x0 + 15*x1 + 10*x2 + 20*x3 <= 176, "c1")
    m.addConstr((13*x0)**2 + (3*x2)**2 + (22*x3)**2 >= 30, "c2")
    m.addConstr(11*x0 + 20*x3 >= 38, "c3")
    m.addConstr(10*x2 + 20*x3 >= 31, "c4")
    m.addConstr(15*x1 + 10*x2 >= 33, "c5")
    m.addConstr(13*x0 + 3*x2 <= 113, "c6")
    m.addConstr(3*x2 + 22*x3 <= 110, "c7")
    m.addConstr(13*x0 + 22*x3 <= 105, "c8")
    m.addConstr(13*x0 + 26*x1 + 3*x2 + 22*x3 <= 105, "c9")
    m.addConstr((11*x0)**2 + (15*x1)**2 <= 161, "c10")
    m.addConstr((15*x1)**2 + (20*x3)**2 <= 133, "c11")
    m.addConstr((15*x1)**2 + (10*x2)**2 <= 92, "c12")
    m.addConstr(10*x2 + 20*x3 <= 174, "c13")
    m.addConstr(11*x0 + 20*x3 <= 61, "c14")
    m.addConstr(15*x1 + 10*x2 + 20*x3 <= 168, "c15")
    m.addConstr((11*x0)**2 + (15*x1)**2 + (10*x2)**2 <= 82, "c16")
    m.addConstr(11*x0 + 15*x1 + 10*x2 + 20*x3 <= 82, "c17")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
