
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="light_infantry_companies", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="signal_platoons", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="logistics_companies", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="medical_platoons", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(2*x0**2 + 6*x0*x1 + 3*x0*x2 + 4*x1**2 + 8*x1*x3 + 6*x2**2 + 8*x2*x3 + 4*x1 + 6*x2 + 9*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*x0 <= 136)
m.addConstr(11*x0 <= 176)
m.addConstr(26*x1 <= 136)
m.addConstr(15*x1 <= 176)
m.addConstr(3*x2 <= 136)
m.addConstr(10*x2 <= 176)
m.addConstr(22*x3 <= 136)
m.addConstr(20*x3 <= 176)
m.addConstr(x0**2 + x2**2 + x3**2 >= 30)
m.addConstr(11*x0 + 20*x3 >= 38)
m.addConstr(10*x2 + 20*x3 >= 31)
m.addConstr(15*x1 + 10*x2 >= 33)
m.addConstr(13*x0 + 3*x2 <= 113)
m.addConstr(3*x2 + 22*x3 <= 110)
m.addConstr(13*x0 + 22*x3 <= 105)
m.addConstr(13*x0 + 26*x1 + 3*x2 + 22*x3 <= 105)
m.addConstr(11**2*x0**2 + 15**2*x1**2 <= 161)
m.addConstr(15**2*x1**2 + 20**2*x3**2 <= 133)
m.addConstr(15**2*x1**2 + 10**2*x2**2 <= 92)
m.addConstr(10*x2 + 20*x3 <= 174)
m.addConstr(11*x0 + 20*x3 <= 61)
m.addConstr(15*x1 + 10*x2 + 20*x3 <= 168)
m.addConstr(11**2*x0**2 + 15**2*x1**2 + 10**2*x2**2 <= 82)
m.addConstr(11*x0 + 15*x1 + 10*x2 + 20*x3 <= 82)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Light infantry companies: {x0.varValue}")
    print(f"Signal platoons: {x1.varValue}")
    print(f"Logistics companies: {x2.varValue}")
    print(f"Medical platoons: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
