
import gurobipy as gp

try:
    m = gp.Model("optimization_problem")

    # Variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Laura")
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_John")

    # Objective function
    m.setObjective(1.13*x0**2 + 5.24*x1**2 + 1.28*x1, gp.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(9*x0 == 9)
    m.addConstr(21*x0 == 21)
    m.addConstr(26*x0 == 26)
    m.addConstr(14*x1 == 14)
    m.addConstr(23*x1 == 23)
    m.addConstr(16*x1 == 16)
    m.addConstr(9*x0 + 14*x1 >= 71)
    m.addConstr(21*x0 + 23*x1 >= 62)
    m.addConstr(26*x0**2 + 16*x1**2 >= 66)
    m.addConstr(3*x0 - 7*x1 >= 0)
    m.addConstr(9*x0 + 14*x1 <= 198)
    m.addConstr(21*x0 + 23*x1 <= 168)
    m.addConstr(26*x0 + 16*x1 <= 121)


    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"hours worked by Laura: {x0.x}")
        print(f"hours worked by John: {x1.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check variable usage.")

