
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Laura", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_John", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1.13*x0**2 + 5.24*x1**2 + 1.28*x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(9*x0 + 14*x1 >= 71, name="likelihood_to_quit_index_constraint")
    model.addConstr(21*x0 + 23*x1 >= 62, name="productivity_rating_constraint")
    model.addConstr(26*x0**2 + 16*x1**2 >= 66, name="work_quality_rating_constraint")
    model.addConstr(3*x0 - 7*x1 >= 0, name="hours_worked_constraint")
    model.addConstr(9*x0 + 14*x1 <= 198, name="likelihood_to_quit_index_upper_bound")
    model.addConstr(21*x0 + 23*x1 <= 168, name="productivity_rating_upper_bound")
    model.addConstr(26*x0**2 + 16*x1**2 <= 121, name="work_quality_rating_upper_bound")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Laura: {x0.varValue}")
        print(f"Hours worked by John: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
