
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    steaks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="steaks")
    peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
    ham_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
    pickles = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pickles")
    chicken_drumsticks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")


    # Set objective function
    m.setObjective(5.13 * steaks + 3.46 * peanutbutter_sandwiches + 4.8 * ham_sandwiches + 8.09 * pickles + 4.59 * chicken_drumsticks, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8 * peanutbutter_sandwiches + 7 * ham_sandwiches >= 21, "c1")
    m.addConstr(8 * steaks + 6 * peanutbutter_sandwiches + 7 * ham_sandwiches >= 21, "c2")
    m.addConstr(-8 * peanutbutter_sandwiches + 3 * pickles + 8 * chicken_drumsticks >= 0, "c3")
    m.addConstr(7 * ham_sandwiches + 9 * chicken_drumsticks <= 46, "c4")
    m.addConstr(8 * steaks + 9 * chicken_drumsticks <= 28, "c5")
    m.addConstr(6 * peanutbutter_sandwiches + 9 * pickles <= 106, "c6")
    m.addConstr(8 * steaks + 6 * peanutbutter_sandwiches + 9 * pickles <= 110, "c7")
    m.addConstr(8 * steaks + 6 * peanutbutter_sandwiches + 7 * ham_sandwiches + 9 * pickles + 9 * chicken_drumsticks <= 141, "c8")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
