
import gurobi

def optimization_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x0 = m.addVar(name="steaks", lb=0)  # steaks
    x1 = m.addVar(name="peanutbutter_sandwiches", lb=0)  # peanutbutter sandwiches
    x2 = m.addVar(name="ham_sandwiches", lb=0)  # ham sandwiches
    x3 = m.addVar(name="pickles", lb=0)  # pickles
    x4 = m.addVar(name="chicken_drumsticks", lb=0)  # chicken drumsticks

    # Objective function
    m.setObjective(5.13*x0 + 3.46*x1 + 4.8*x2 + 8.09*x3 + 4.59*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(6*x1 + 7*x2 >= 21)  # at least $21 on peanutbutter sandwiches and ham sandwiches
    m.addConstr(8*x0 + 6*x1 + 7*x2 >= 21)  # at least $21 on steaks, peanutbutter sandwiches, and ham sandwiches
    m.addConstr(-8*x1 + 3*x3 + 8*x4 >= 0)
    m.addConstr(7*x2 + 9*x4 <= 46)  # no more than $46 on ham sandwiches and chicken drumsticks
    m.addConstr(8*x0 + 9*x4 <= 28)  # no more than $28 on steaks and chicken drumsticks
    m.addConstr(6*x1 + 9*x3 <= 106)  # no more than $106 on peanutbutter sandwiches and pickles
    m.addConstr(8*x0 + 6*x1 + 9*x3 <= 110)  # no more than $110 on steaks, peanutbutter sandwiches, and pickles
    m.addConstr(8*x0 + 6*x1 + 7*x2 + 9*x3 + 9*x4 <= 141)  # no more than $141 total

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", m.objVal)
        print("Steaks: ", x0.varValue)
        print("Peanutbutter sandwiches: ", x1.varValue)
        print("Ham sandwiches: ", x2.varValue)
        print("Pickles: ", x3.varValue)
        print("Chicken drumsticks: ", x4.varValue)
    else:
        print("The problem is infeasible")

optimization_problem()
