
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")
paul = model.addVar(vtype=gp.GRB.INTEGER, name="paul")
hank = model.addVar(vtype=gp.GRB.INTEGER, name="hank")
peggy = model.addVar(vtype=gp.GRB.INTEGER, name="peggy")


# Set objective function
model.setObjective(5*ringo + 4*paul + 4*hank + 5*peggy, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(17*ringo + 23*paul >= 60)
model.addConstr(17*ringo + 6*hank >= 35)
model.addConstr(23*paul + 6*hank + 17*peggy >= 77)
model.addConstr(17*ringo + 23*paul + 6*hank + 17*peggy >= 77)
model.addConstr(7*ringo + 18*hank >= 19)
model.addConstr(23*paul + 19*peggy >= 24)
model.addConstr(7*ringo + 19*peggy >= 36)
model.addConstr(7*ringo + 23*paul + 19*peggy >= 35)
model.addConstr(7*ringo + 23*paul + 18*hank >= 35)
model.addConstr(7*ringo + 23*paul + 19*peggy >= 37)
model.addConstr(7*ringo + 23*paul + 18*hank >= 37)
model.addConstr(7*ringo + 23*paul + 18*hank + 19*peggy >= 37)
model.addConstr(4*paul - 8*hank >= 0)
model.addConstr(-8*paul + 10*peggy >= 0)
model.addConstr(-7*ringo + 9*hank + 10*peggy >= 0)
model.addConstr(17*ringo + 23*paul + 17*peggy <= 231)
model.addConstr(17*ringo + 6*hank + 17*peggy <= 104)
model.addConstr(23*paul + 6*hank + 17*peggy <= 96)
model.addConstr(17*ringo + 23*paul + 6*hank <= 276)
model.addConstr(7*ringo + 23*paul <= 58)
model.addConstr(23*paul + 18*hank <= 118)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Ringo:', ringo.x)
    print('Paul:', paul.x)
    print('Hank:', hank.x)
    print('Peggy:', peggy.x)
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

