
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER)  # hours worked by Ringo
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # hours worked by Paul
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # hours worked by Hank
x3 = m.addVar(name="x3", vtype=gp.GRB.INTEGER)  # hours worked by Peggy

# Define the objective function
m.setObjective(5 * x0 + 4 * x1 + 4 * x2 + 5 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(17 * x0 + 23 * x1 >= 60)
m.addConstr(17 * x0 + 6 * x2 >= 35)
m.addConstr(23 * x1 + 6 * x2 + 17 * x3 >= 77)
m.addConstr(17 * x0 + 23 * x1 + 6 * x2 + 17 * x3 >= 77)
m.addConstr(7 * x0 + 18 * x2 >= 19)
m.addConstr(23 * x1 + 19 * x3 >= 24)
m.addConstr(7 * x0 + 19 * x3 >= 36)
m.addConstr(7 * x0 + 23 * x1 + 19 * x3 >= 35)
m.addConstr(7 * x0 + 23 * x1 + 18 * x2 >= 35)
m.addConstr(7 * x0 + 23 * x1 + 18 * x2 >= 37)
m.addConstr(7 * x0 + 23 * x1 + 18 * x2 + 19 * x3 >= 37)
m.addConstr(4 * x1 - 8 * x2 >= 0)
m.addConstr(-8 * x1 + 10 * x3 >= 0)
m.addConstr(-7 * x0 + 9 * x2 + 10 * x3 >= 0)
m.addConstr(17 * x0 + 23 * x1 + 17 * x3 <= 231)
m.addConstr(17 * x0 + 6 * x2 + 17 * x3 <= 104)
m.addConstr(23 * x1 + 6 * x2 + 17 * x3 <= 96)
m.addConstr(17 * x0 + 23 * x1 + 6 * x2 <= 276)
m.addConstr(7 * x0 + 23 * x1 <= 58)
m.addConstr(23 * x1 + 18 * x2 <= 118)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Ringo: ", x0.varValue)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
    print("Hours worked by Peggy: ", x3.varValue)
else:
    print("The problem is infeasible")
