
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")


    # Set objective function
    m.setObjective(9*x0 + 2*x1 + 5*x2 + 2*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(22*x2 + 5*x3 >= 57)
    m.addConstr(22*x0 + 5*x3 >= 25)
    m.addConstr(22*x0 + 6*x1 >= 23)
    m.addConstr(22*x0 + 7*x2 + 5*x3 >= 41)
    m.addConstr(22*x0 + 6*x1 + 7*x2 >= 41)
    m.addConstr(22*x0 + 7*x2 + 5*x3 >= 45)
    m.addConstr(22*x0 + 6*x1 + 7*x2 >= 45)
    m.addConstr(22*x0 + 6*x1 + 7*x2 + 5*x3 >= 45)
    m.addConstr(32*x0 + 9*x1 >= 87)
    m.addConstr(32*x0 + 28*x2 >= 61)
    m.addConstr(9*x1 + 28*x2 >= 49)
    m.addConstr(32*x0 + 9*x1 + 28*x2 + 28*x3 >= 49)
    m.addConstr(-8*x1 + 5*x3 >= 0)
    m.addConstr(-1*x1 + 10*x2 >= 0)
    m.addConstr(22*x0 + 6*x1 + 7*x2 <= 239)
    m.addConstr(9*x1 + 28*x3 <= 430)
    m.addConstr(32*x0 + 28*x3 <= 384)
    m.addConstr(32*x0 + 9*x1 <= 313)
    m.addConstr(9*x1 + 28*x2 <= 130)
    m.addConstr(28*x2 + 28*x3 <= 193)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
