
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', lb=0)  # hours worked by John
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Laura
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Hank
    x3 = model.addVar(name='x3', lb=0)  # hours worked by Ringo

    # Define the objective function
    model.setObjective(9 * x0 + 2 * x1 + 5 * x2 + 2 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(22 * x0 <= 256)
    model.addConstr(32 * x0 <= 432)
    model.addConstr(6 * x1 <= 256)
    model.addConstr(9 * x1 <= 432)
    model.addConstr(7 * x2 <= 256)
    model.addConstr(28 * x2 <= 432)
    model.addConstr(5 * x3 <= 256)
    model.addConstr(28 * x3 <= 432)
    model.addConstr(7 * x2 + 5 * x3 >= 57)
    model.addConstr(22 * x0 + 5 * x3 >= 25)
    model.addConstr(22 * x0 + 6 * x1 >= 23)
    model.addConstr(22 * x0 + 7 * x2 + 5 * x3 >= 41)
    model.addConstr(22 * x0 + 6 * x1 + 7 * x2 >= 41)
    model.addConstr(22 * x0 + 7 * x2 + 5 * x3 >= 45)
    model.addConstr(22 * x0 + 6 * x1 + 7 * x2 >= 45)
    model.addConstr(22 * x0 + 6 * x1 + 7 * x2 + 5 * x3 >= 45)
    model.addConstr(32 * x0 + 9 * x1 >= 87)
    model.addConstr(32 * x0 + 28 * x2 >= 61)
    model.addConstr(9 * x1 + 28 * x2 >= 49)
    model.addConstr(32 * x0 + 9 * x1 + 28 * x2 + 28 * x3 >= 49)
    model.addConstr(-8 * x1 + 5 * x3 >= 0)
    model.addConstr(-x1 + 10 * x2 >= 0)
    model.addConstr(22 * x0 + 6 * x1 + 7 * x2 <= 239)
    model.addConstr(9 * x1 + 28 * x3 <= 430)
    model.addConstr(32 * x0 + 28 * x3 <= 384)
    model.addConstr(32 * x0 + 9 * x1 <= 313)
    model.addConstr(9 * x1 + 28 * x2 <= 130)
    model.addConstr(28 * x2 + 28 * x3 <= 193)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x0: ', x0.varValue)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
