
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Labor_Cost")

# Create variables
bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")


# Set objective function
model.setObjective(7.25 * bobby + 6.29 * bill + 1.38 * mary + 5.76 * peggy, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * mary + 25 * peggy >= 59)
model.addConstr(20 * bobby + 4 * mary >= 59)
model.addConstr(24 * bill + 25 * peggy >= 95)
model.addConstr(20 * bobby + 24 * bill >= 95)
model.addConstr(24 * bill + 4 * mary + 25 * peggy >= 116)
model.addConstr(20 * bobby + 24 * bill + 4 * mary >= 116)
model.addConstr(20 * bobby + 24 * bill + 25 * peggy >= 116)
model.addConstr(24 * bill + 4 * mary + 25 * peggy >= 81)
model.addConstr(20 * bobby + 24 * bill + 4 * mary >= 81)
model.addConstr(20 * bobby + 24 * bill + 25 * peggy >= 81)
model.addConstr(24 * bill + 4 * mary + 25 * peggy >= 70)
model.addConstr(20 * bobby + 24 * bill + 4 * mary >= 70)
model.addConstr(20 * bobby + 24 * bill + 25 * peggy >= 70)
model.addConstr(20 * bobby + 24 * bill + 4 * mary + 25 * peggy >= 70)
model.addConstr(bill + 22 * mary >= 72)
model.addConstr(22 * mary + 21 * peggy >= 25)
model.addConstr(2 * bobby + bill >= 32)
model.addConstr(2 * bobby + 21 * peggy >= 69)
model.addConstr(2 * bobby + 22 * mary >= 48)
model.addConstr(2 * bobby + bill + 21 * peggy >= 51)
model.addConstr(2 * bobby + bill + 22 * mary + 21 * peggy >= 51)
model.addConstr(8 * bobby + 2 * mary >= 56)
model.addConstr(26 * bill + 2 * mary >= 82)
model.addConstr(8 * bobby + 26 * bill >= 56)
model.addConstr(8 * bobby + 2 * mary + 18 * peggy >= 68)
model.addConstr(8 * bobby + 26 * bill + 2 * mary >= 68)
model.addConstr(8 * bobby + 2 * mary + 18 * peggy >= 64)
model.addConstr(8 * bobby + 26 * bill + 2 * mary >= 64)
model.addConstr(8 * bobby + 26 * bill + 2 * mary + 18 * peggy >= 64)
model.addConstr(23 * mary + 4 * peggy >= 94)
model.addConstr(18 * bobby + 23 * mary + 4 * peggy >= 121)
model.addConstr(18 * bobby + 29 * bill + 23 * mary >= 121)
model.addConstr(29 * bill + 23 * mary + 4 * peggy >= 121)
model.addConstr(18 * bobby + 23 * mary + 4 * peggy >= 130)
model.addConstr(18 * bobby + 29 * bill + 23 * mary >= 130)
model.addConstr(29 * bill + 23 * mary + 4 * peggy >= 130)
model.addConstr(18 * bobby + 23 * mary + 4 * peggy >= 125)
model.addConstr(18 * bobby + 29 * bill + 23 * mary >= 125)
model.addConstr(29 * bill + 23 * mary + 4 * peggy >= 125)
model.addConstr(18 * bobby + 29 * bill + 23 * mary + 4 * peggy >= 125)
model.addConstr(5 * bobby - mary >= 0)
model.addConstr(-5 * bill + 3 * peggy >= 0)
model.addConstr(20 * bobby + 25 * peggy <= 353)
model.addConstr(20 * bobby + 24 * bill <= 497)
model.addConstr(20 * bobby + 4 * mary <= 476)
model.addConstr(24 * bill + 4 * mary <= 502)
model.addConstr(20 * bobby + 24 * bill + 4 * mary <= 317)
model.addConstr(20 * bobby + 4 * mary + 25 * peggy <= 548)
model.addConstr(22 * mary + 21 * peggy <= 169)
model.addConstr(bill + 21 * peggy <= 106)
model.addConstr(bill + 22 * mary + 21 * peggy <= 130)
model.addConstr(2 * bobby + 22 * mary + 21 * peggy <= 101)
model.addConstr(26 * bill + 18 * peggy <= 115)
model.addConstr(2 * mary + 18 * peggy <= 227)
model.addConstr(8 * bobby + 2 * mary + 18 * peggy <= 295)
model.addConstr(29 * bill + 23 * mary + 4 * peggy <= 345)
model.addConstr(18 * bobby + 29 * bill + 4 * peggy <= 548)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

