
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="hot_dogs", lb=0)  # hot dogs
x2 = m.addVar(name="slices_of_pizza", lb=0)  # slices of pizza
x3 = m.addVar(name="chicken_drumsticks", lb=0)  # chicken drumsticks

# Define the objective function
m.setObjective(2 * x1 + 9 * x2 + 6 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.69 * x1 + 3.25 * x2 + 1.51 * x3 >= 11)
m.addConstr(2.7 * x1 + 2.23 * x2 >= 5)
m.addConstr(1.64 * x1 + 3.26 * x2 + 4.61 * x3 >= 10)
m.addConstr(4.59 * x1 + 0.72 * x2 + 3.06 * x3 >= 10)
m.addConstr(0.94 * x2 + 0.45 * x3 <= 37)
m.addConstr(4.97 * x1 + 0.45 * x3 <= 41)
m.addConstr(4.97 * x1 + 0.94 * x2 <= 28)
m.addConstr(4.97 * x1 + 0.94 * x2 + 0.45 * x3 <= 28)
m.addConstr(0.69 * x1 + 1.51 * x3 <= 41)
m.addConstr(3.25 * x2 + 1.51 * x3 <= 29)
m.addConstr(0.69 * x1 + 3.25 * x2 + 1.51 * x3 <= 29)
m.addConstr(2.23 * x2 + 4.0 * x3 <= 18)
m.addConstr(2.7 * x1 + 2.23 * x2 + 4.0 * x3 <= 18)
m.addConstr(3.26 * x2 + 4.61 * x3 <= 22)
m.addConstr(1.64 * x1 + 4.61 * x3 <= 26)
m.addConstr(1.64 * x1 + 3.26 * x2 + 4.61 * x3 <= 26)
m.addConstr(4.59 * x1 + 0.72 * x2 <= 18)
m.addConstr(0.72 * x2 + 3.06 * x3 <= 25)
m.addConstr(4.59 * x1 + 0.72 * x2 + 3.06 * x3 <= 25)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hot dogs: ", x1.varValue)
    print("Slices of pizza: ", x2.varValue)
    print("Chicken drumsticks: ", x3.varValue)
else:
    print("The model is infeasible")
