
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
packs_of_paper_plates = model.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")
packs_of_napkins = model.addVar(vtype=GRB.INTEGER, name="packs_of_napkins")


# Set objective function
model.setObjective(2.53 * packs_of_paper_plates + 1.37 * packs_of_napkins, GRB.MAXIMIZE)

# Add constraints
model.addConstr(7 * packs_of_paper_plates + 9 * packs_of_napkins >= 33, "sustainability_score_min")
model.addConstr(10 * packs_of_paper_plates - 10 * packs_of_napkins >= 0, "paper_plates_napkins_relation")
model.addConstr(7 * packs_of_paper_plates + 9 * packs_of_napkins <= 47, "sustainability_score_max1")
model.addConstr(7 * packs_of_paper_plates + 9 * packs_of_napkins <= 47, "sustainability_score_max2")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Packs of paper plates: {packs_of_paper_plates.x}")
    print(f"Packs of napkins: {packs_of_napkins.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

