
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")
x2 = m.addVar(vtype=GRB.INTEGER, name="packs_of_napkins")

# Set the objective function
m.setObjective(2.53*x1 + 1.37*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 9*x2 >= 33, "sustainability_score_min")
m.addConstr(10*x1 - 10*x2 >= 0, "linear_constraint")
m.addConstr(7*x1 + 9*x2 <= 47, "sustainability_score_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Packs of paper plates: {x1.x}")
    print(f"Packs of napkins: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
