
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="packs_of_paper_plates", vtype=gp.GRB.INTEGER)  # packs of paper plates
x2 = m.addVar(name="packs_of_napkins", vtype=gp.GRB.INTEGER)  # packs of napkins

# Set the objective function
m.setObjective(2.53 * x1 + 1.37 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * x1 + 9 * x2 >= 33, name="sustainability_score_min")
m.addConstr(10 * x1 - 10 * x2 >= 0, name="ratio_constraint")
m.addConstr(7 * x1 + 9 * x2 <= 47, name="sustainability_score_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Packs of paper plates: {x1.varValue}")
    print(f"Packs of napkins: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
