
import gurobipy as gp

# Create a new model
m = gp.Model("likelihood_optimization")

# Create variables
bill = m.addVar(vtype=gp.GRB.INTEGER, name="bill")
john = m.addVar(vtype=gp.GRB.INTEGER, name="john")
ringo = m.addVar(vtype=gp.GRB.INTEGER, name="ringo")
laura = m.addVar(vtype=gp.GRB.INTEGER, name="laura")
mary = m.addVar(vtype=gp.GRB.INTEGER, name="mary")
hank = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hank")

# Set objective function
m.setObjective(1.72 * bill + 3.31 * john + 5.24 * ringo + 6.21 * laura + 2.25 * mary + 7.84 * hank, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.66 * bill + 7.4 * hank >= 15)
m.addConstr(8.37 * john + 9.3 * mary >= 7)
m.addConstr(11.19 * ringo + 9.3 * mary >= 13)
m.addConstr(1.66 * bill + 9.3 * mary >= 10)
m.addConstr(8.37 * john + 11.19 * ringo >= 19)
m.addConstr(14.76 * laura + 7.4 * hank >= 10)
m.addConstr(11.19 * ringo + 7.4 * hank >= 12)
m.addConstr(8.37 * john + 7.4 * hank >= 6)
m.addConstr(9.3 * mary + 7.4 * hank >= 15)
m.addConstr(1.66 * bill + 8.37 * john + 14.76 * laura >= 16)
m.addConstr(8.37 * john + 11.19 * ringo + 14.76 * laura >= 16)
m.addConstr(1.66 * bill + 9.3 * mary + 7.4 * hank >= 16)
m.addConstr(11.19 * ringo + 14.76 * laura + 9.3 * mary >= 16)
m.addConstr(1.66 * bill + 8.37 * john + 11.19 * ringo >= 16)
m.addConstr(1.66 * bill + 11.19 * ringo + 9.3 * mary >= 16)
m.addConstr(1.66 * bill + 8.37 * john + 9.3 * mary >= 16)
m.addConstr(8.37 * john + 14.76 * laura + 9.3 * mary >= 16)
m.addConstr(8.37 * john + 11.19 * ringo + 9.3 * mary >= 16)
m.addConstr(1.66 * bill + 11.19 * ringo + 14.76 * laura >= 16)
m.addConstr(1.66 * bill + 14.76 * laura + 9.3 * mary >= 16)
m.addConstr(1.66 * bill + 8.37 * john + 7.4 * hank >= 16)
m.addConstr(8.37 * john + 14.76 * laura + 7.4 * hank >= 16)


m.addConstr(11.19 * ringo + 7.4 * hank <= 97)
m.addConstr(8.37 * john + 14.76 * laura <= 121)
m.addConstr(1.66 * bill + 14.76 * laura <= 80)
m.addConstr(11.19 * ringo + 9.3 * mary <= 109)
m.addConstr(1.66 * bill + 7.4 * hank <= 21)
m.addConstr(1.66 * bill + 9.3 * mary <= 82)
m.addConstr(1.66 * bill + 8.37 * john <= 118)
m.addConstr(14.76 * laura + 9.3 * mary <= 76)
m.addConstr(9.3 * mary + 7.4 * hank <= 93)
m.addConstr(1.66 * bill + 8.37 * john + 11.19 * ringo + 14.76 * laura + 9.3 * mary + 7.4 * hank <= 93)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

