
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("fruit_optimization")

    # Create variables
    bananas = m.addVar(lb=0, name="bananas")  # Non-negative
    apples = m.addVar(lb=0, name="apples")  # Non-negative


    # Set objective function
    m.setObjective(6.16 * bananas + 1.89 * apples, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * bananas + 4 * apples >= 28, "min_cost")
    m.addConstr(2 * bananas + 1 * apples >= 12, "min_fiber")
    m.addConstr(10 * bananas - 4 * apples >= 0, "banana_apple_ratio")
    m.addConstr(3 * bananas + 4 * apples <= 41, "max_cost")
    m.addConstr(2 * bananas + 1 * apples <= 29, "max_fiber")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('bananas: %g' % bananas.x)
        print('apples: %g' % apples.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')

