
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="bananas")
x2 = m.addVar(lb=0, name="apples")

# Set the objective function
m.setObjective(6.16*x1 + 1.89*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 4*x2 >= 28, "Minimum_Spend")
m.addConstr(3*x1 + 4*x2 <= 41, "Maximum_Spend")
m.addConstr(2*x1 + x2 >= 12, "Minimum_Fiber")
m.addConstr(2*x1 + x2 <= 29, "Maximum_Fiber")
m.addConstr(10*x1 - 4*x2 >= 0, "Mixed_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bananas: {x1.x}, Apples: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
