
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    bananas = model.addVar(name="bananas", lb=0)  # No upper bound, can be continuous
    apples = model.addVar(name="apples", lb=0)   # No upper bound, can be continuous

    # Define the objective function
    model.setObjective(6.16 * bananas + 1.89 * apples, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * bananas + 4 * apples >= 28)  # Minimum spend $28
    model.addConstr(2 * bananas + apples >= 12)     # Minimum fiber 12 grams
    model.addConstr(10 * bananas - 4 * apples >= 0) # Relationship between bananas and apples
    model.addConstr(3 * bananas + 4 * apples <= 41) # Maximum spend $41
    model.addConstr(2 * bananas + apples <= 29)     # Maximum fiber 29 grams

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bananas: {bananas.varValue}")
        print(f"Apples: {apples.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
