
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="monochrome_printers")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="postage_stamps")


    # Set objective function
    model.setObjective(4.43 * x0 + 3.06 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * x0 + 13 * x1 >= 38, "c0")
    model.addConstr(-8 * x0 + 4 * x1 >= 0, "c1")
    model.addConstr(12 * x0 + 13 * x1 <= 72, "c2")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Monochrome Printers: {x0.x}")
        print(f"Postage Stamps: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
