
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.INTEGER, name="monochrome_printers")
x2 = m.addVar(vtype=GRB.INTEGER, name="postage_stamps")

# Set objective function
m.setObjective(4.43*x1 + 3.06*x2, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(12*x1 + 13*x2 >= 38, "usefulness_rating_min")
m.addConstr(12*x1 + 13*x2 <= 72, "usefulness_rating_max")
m.addConstr(-8*x1 + 4*x2 >= 0, "linear_inequality")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Monochrome printers: {x1.x}")
    print(f"Postage stamps: {x2.x}")
else:
    print("No optimal solution found")
