
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="monochrome_printers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="postage_stamps", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4.43 * x1 + 3.06 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * x1 + 13 * x2 >= 38, name="usefulness_rating_min")
    model.addConstr(-8 * x1 + 4 * x2 >= 0, name="ratio_constraint")
    model.addConstr(12 * x1 + 13 * x2 <= 72, name="usefulness_rating_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Monochrome printers: {x1.varValue}")
        print(f"Postage stamps: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
