
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Hours")

# Create variables
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura")
ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Ringo")


# Set objective function
model.setObjective(9.55 * peggy + 4.63 * laura + 1.21 * ringo, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * laura + 6 * ringo >= 26, "c1")
model.addConstr(2 * peggy + 8 * laura >= 18, "c2")
model.addConstr(2 * peggy + 8 * laura + 6 * ringo >= 18, "c3")
model.addConstr(8 * laura + 7 * ringo >= 10, "c4")
model.addConstr(6 * peggy + 8 * laura + 7 * ringo >= 12, "c5")
model.addConstr(6 * peggy + 8 * laura + 7 * ringo >= 12, "c6")  # Redundant constraint
model.addConstr(6 * peggy + 10 * laura >= 22, "c7")
model.addConstr(10 * laura + 1 * ringo >= 20, "c8")
model.addConstr(6 * peggy + 10 * laura + 1 * ringo >= 20, "c9")
model.addConstr(-3 * peggy + 9 * laura >= 0, "c10")
model.addConstr(8 * laura + 6 * ringo <= 86, "c11")
model.addConstr(2 * peggy + 6 * ringo <= 80, "c12")
model.addConstr(6 * peggy + 7 * ringo <= 30, "c13")
model.addConstr(6 * peggy + 10 * laura <= 78, "c14")
model.addConstr(6 * peggy + 1 * ringo <= 95, "c15")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Peggy:', peggy.x)
    print('Laura:', laura.x)
    print('Ringo:', ringo.x)
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

