
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", lb=0)  # hours worked by Peggy
x1 = model.addVar(name="x1", lb=0)  # hours worked by Laura
x2 = model.addVar(name="x2", lb=0)  # hours worked by Ringo

# Objective function
model.setObjective(9.55 * x0 + 4.63 * x1 + 1.21 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(8 * x1 + 6 * x2 >= 26)  # organization score from Laura and Ringo
model.addConstr(2 * x0 + 8 * x1 >= 18)  # organization score from Peggy and Laura
model.addConstr(2 * x0 + 8 * x1 + 6 * x2 >= 18)  # organization score from all
model.addConstr(8 * x1 + 7 * x2 >= 10)  # work quality rating from Laura and Ringo
model.addConstr(6 * x0 + 8 * x1 + 7 * x2 >= 12)  # work quality rating from all
model.addConstr(6 * x0 + 10 * x1 >= 22)  # dollar cost from Peggy and Laura
model.addConstr(10 * x1 + 1 * x2 >= 20)  # dollar cost from Laura and Ringo
model.addConstr(6 * x0 + 10 * x1 + 1 * x2 >= 20)  # dollar cost from all
model.addConstr(-3 * x0 + 9 * x1 >= 0)  # constraint on Peggy and Laura
model.addConstr(8 * x1 + 6 * x2 <= 86)  # organization score limit from Laura and Ringo
model.addConstr(2 * x0 + 6 * x2 <= 80)  # organization score limit from Peggy and Ringo
model.addConstr(6 * x0 + 7 * x2 <= 30)  # work quality rating limit from Peggy and Ringo
model.addConstr(6 * x0 + 10 * x1 <= 78)  # dollar cost limit from Peggy and Laura
model.addConstr(6 * x0 + 1 * x2 <= 95)  # dollar cost limit from Peggy and Ringo

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Hours worked by Peggy: ", x0.varValue)
    print("Hours worked by Laura: ", x1.varValue)
    print("Hours worked by Ringo: ", x2.varValue)
else:
    print("The model is infeasible")
