
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("diet_problem")

# Create variables
black_beans = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_beans")
steaks = m.addVar(lb=0, vtype=GRB.INTEGER, name="steaks")


# Set objective function
m.setObjective(1 * black_beans + 7 * steaks, GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * black_beans + 9 * steaks >= 18, "iron_min")
m.addConstr(3 * black_beans + 7 * steaks >= 22, "cost_min")
m.addConstr(1 * black_beans + 3 * steaks >= 11, "fiber_min")
m.addConstr(10 * black_beans - 1 * steaks >= 0, "black_beans_steaks_relation")
m.addConstr(1 * black_beans + 9 * steaks <= 71, "iron_max")
m.addConstr(3 * black_beans + 7 * steaks <= 45, "cost_max")
m.addConstr(1 * black_beans + 3 * steaks <= 28, "fiber_max")



# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('black_beans:', black_beans.x)
    print('steaks:', steaks.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

