
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_beans")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="steaks")

# Set the objective function
m.setObjective(1*x0 + 7*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(1*x0 + 9*x1 >= 18, "iron_constraint")
m.addConstr(1*x0 + 9*x1 <= 71, "iron_upper_bound")
m.addConstr(3*x0 + 7*x1 >= 22, "cost_constraint")
m.addConstr(3*x0 + 7*x1 <= 45, "cost_upper_bound")
m.addConstr(1*x0 + 3*x1 >= 11, "fiber_constraint")
m.addConstr(1*x0 + 3*x1 <= 28, "fiber_upper_bound")
m.addConstr(10*x0 - x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Black beans: {x0.x}")
    print(f"Steaks: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
