
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="black_beans", lb=0)  # Continuous variable for black beans
    x2 = model.addVar(name="steaks", lb=0, integrality=gurobi.GRB.INTEGER)  # Integer variable for steaks

    # Define objective function
    model.setObjective(x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Define constraints
    model.addConstr(x1 + 9 * x2 >= 18, name="iron_constraint")
    model.addConstr(3 * x1 + 7 * x2 >= 22, name="cost_constraint")
    model.addConstr(x1 + 3 * x2 >= 11, name="fiber_constraint")
    model.addConstr(10 * x1 - x2 >= 0, name="relationship_constraint")
    model.addConstr(x1 + 9 * x2 <= 71, name="max_iron_constraint")
    model.addConstr(3 * x1 + 7 * x2 <= 45, name="max_cost_constraint")
    model.addConstr(x1 + 3 * x2 <= 28, name="max_fiber_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Black beans: {x1.varValue}")
        print(f"Steaks: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
