
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Hours_Worked")

# Create variables
ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")


# Set objective function
model.setObjective(6 * ringo + 1 * jean + 6 * paul, gp.GRB.MINIMIZE)

# Add constraints

# Redundant constraints related to individual attribute values are omitted.
model.addConstr(7 * jean + 3 * paul >= 15, "c1")
model.addConstr(18 * ringo + 7 * jean + 3 * paul >= 24, "c2")
model.addConstr(2 * jean + 11 * paul >= 36, "c3")
model.addConstr(6 * ringo + 2 * jean + 11 * paul >= 36, "c4")
model.addConstr(-1 * jean + 1 * paul >= 0, "c5")
model.addConstr(2 * jean + 11 * paul <= 111, "c6")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('Ringo:', ringo.x)
    print('Jean:', jean.x)
    print('Paul:', paul.x)
elif model.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")

