
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='hours_worked_by_Ringo', lb=0)
    x1 = model.addVar(name='hours_worked_by_Jean', lb=0)
    x2 = model.addVar(name='hours_worked_by_Paul', lb=0)

    # Define the objective function
    model.setObjective(6*x0 + x1 + 6*x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(7*x1 + 3*x2 >= 15)
    model.addConstr(18*x0 + 7*x1 + 3*x2 >= 24)
    model.addConstr(2*x1 + 11*x2 >= 36)
    model.addConstr(6*x0 + 2*x1 + 11*x2 >= 36)
    model.addConstr(-x1 + x2 >= 0)
    model.addConstr(2*x1 + 11*x2 <= 111)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Ringo: ', x0.varValue)
        print('Hours worked by Jean: ', x1.varValue)
        print('Hours worked by Paul: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
