
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER, lb=0)  # hours worked by Peggy
x1 = m.addVar(name="x1", vtype=gp.GRB.CONTINUOUS, lb=0)  # hours worked by Paul
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER, lb=0)  # hours worked by Hank

# Define the objective function
m.setObjective(7*x0 + 3*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x0 + x1 + 8*x2 >= 12)  # productivity rating
m.addConstr(3*x0 + 2*x2 <= 27)  # paperwork competence rating (Peggy, Hank)
m.addConstr(7*x1 + 2*x2 <= 27)  # paperwork competence rating (Paul, Hank)
m.addConstr(3*x0 + 7*x1 <= 34)  # paperwork competence rating (Peggy, Paul)
m.addConstr(3*x0 + 7*x1 + 2*x2 <= 34)  # paperwork competence rating (all)
m.addConstr(x1 + 8*x2 <= 29)  # productivity rating (Paul, Hank)
m.addConstr(x0 + x1 <= 33)  # productivity rating (Peggy, Paul)
m.addConstr(x0 + x1 + 8*x2 <= 33)  # productivity rating (all)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Peggy: {x0.varValue}")
    print(f"Hours worked by Paul: {x1.varValue}")
    print(f"Hours worked by Hank: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
