
import gurobipy as gp

# Create a new model
model = gp.Model("fruit_optimization")

# Create variables
kiwis = model.addVar(vtype=gp.GRB.INTEGER, name="kiwis")
cantaloupes = model.addVar(vtype=gp.GRB.INTEGER, name="cantaloupes")
cherry_pies = model.addVar(vtype=gp.GRB.INTEGER, name="cherry_pies")
cornichons = model.addVar(vtype=gp.GRB.CONTINUOUS, name="cornichons")

# Set objective function
model.setObjective(1*kiwis + 5*cantaloupes + 7*cherry_pies + 7*cornichons, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(5*kiwis + 9*cornichons >= 59, "c0")
model.addConstr(20*cantaloupes + 2*cherry_pies >= 42, "c1")
model.addConstr(2*cherry_pies + 9*cornichons >= 55, "c2")
model.addConstr(5*kiwis + 2*cherry_pies >= 39, "c3")
model.addConstr(5*kiwis + 20*cantaloupes + 2*cherry_pies + 9*cornichons >= 39, "c4")
model.addConstr(6*cherry_pies - 3*cornichons >= 0, "c5")
model.addConstr(-9*cantaloupes + 2*cherry_pies >= 0, "c6")
model.addConstr(5*kiwis + 20*cantaloupes + 2*cherry_pies + 9*cornichons <= 261, "carbohydrate_limit")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('kiwis:', kiwis.x)
    print('cantaloupes:', cantaloupes.x)
    print('cherry_pies:', cherry_pies.x)
    print('cornichons:', cornichons.x)
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

