
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")


# Set objective function
m.setObjective(7 * vitamin_b5 + 6 * vitamin_c + 2 * vitamin_a + 8 * vitamin_d, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * vitamin_b5 + 9 * vitamin_a + 8 * vitamin_d >= 31)
m.addConstr(13 * vitamin_c + 9 * vitamin_a + 8 * vitamin_d >= 31)
m.addConstr(13 * vitamin_b5 + 9 * vitamin_a + 8 * vitamin_d >= 30)
m.addConstr(13 * vitamin_c + 9 * vitamin_a + 8 * vitamin_d >= 30)
m.addConstr(13 * vitamin_b5 + 13 * vitamin_c + 9 * vitamin_a + 8 * vitamin_d >= 30)
m.addConstr(10 * vitamin_b5 + 5 * vitamin_a >= 18)
m.addConstr(10 * vitamin_b5 + 4 * vitamin_d >= 35)
m.addConstr(10 * vitamin_b5 + 1 * vitamin_c >= 27)
m.addConstr(1 * vitamin_c + 5 * vitamin_a >= 12)
m.addConstr(1 * vitamin_c + 4 * vitamin_d >= 24)
m.addConstr(10 * vitamin_b5 + 5 * vitamin_a + 4 * vitamin_d >= 25)
m.addConstr(10 * vitamin_b5 + 1 * vitamin_c + 5 * vitamin_a + 4 * vitamin_d >= 25)
m.addConstr(-10 * vitamin_b5 + 7 * vitamin_a >= 0)
m.addConstr(2 * vitamin_c - 6 * vitamin_d >= 0)
m.addConstr(13 * vitamin_b5 + 13 * vitamin_c <= 83)
m.addConstr(13 * vitamin_b5 + 8 * vitamin_d <= 141)
m.addConstr(13 * vitamin_b5 + 9 * vitamin_a <= 133)
m.addConstr(13 * vitamin_b5 + 13 * vitamin_c + 8 * vitamin_d <= 91)
m.addConstr(13 * vitamin_b5 + 13 * vitamin_c + 9 * vitamin_a <= 132)
m.addConstr(13 * vitamin_c + 9 * vitamin_a + 8 * vitamin_d <= 145)
m.addConstr(10 * vitamin_b5 + 5 * vitamin_a <= 111)
m.addConstr(5 * vitamin_a + 4 * vitamin_d <= 124)
m.addConstr(10 * vitamin_b5 + 4 * vitamin_d <= 63)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

