
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # milligrams of vitamin B5
x1 = m.addVar(name="x1", lb=0)  # milligrams of vitamin C
x2 = m.addVar(name="x2", lb=0)  # milligrams of vitamin A
x3 = m.addVar(name="x3", lb=0)  # milligrams of vitamin D

# Define the objective function
m.setObjective(7 * x0 + 6 * x1 + 2 * x2 + 8 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * x0 <= 157)
m.addConstr(10 * x0 <= 143)
m.addConstr(13 * x1 <= 157)
m.addConstr(x1 <= 143)
m.addConstr(9 * x2 <= 157)
m.addConstr(5 * x2 <= 143)
m.addConstr(8 * x3 <= 157)
m.addConstr(4 * x3 <= 143)
m.addConstr(13 * x0 + 9 * x2 + 8 * x3 >= 31)
m.addConstr(13 * x1 + 9 * x2 + 8 * x3 >= 31)
m.addConstr(13 * x0 + 9 * x2 + 8 * x3 >= 30)
m.addConstr(13 * x1 + 9 * x2 + 8 * x3 >= 30)
m.addConstr(13 * x0 + 13 * x1 + 9 * x2 + 8 * x3 >= 30)
m.addConstr(10 * x0 + 5 * x2 >= 18)
m.addConstr(10 * x0 + 4 * x3 >= 35)
m.addConstr(10 * x0 + x1 >= 27)
m.addConstr(x1 + 5 * x2 >= 12)
m.addConstr(x1 + 4 * x3 >= 24)
m.addConstr(10 * x0 + 5 * x2 + 4 * x3 >= 25)
m.addConstr(10 * x0 + x1 + 5 * x2 + 4 * x3 >= 25)
m.addConstr(-10 * x0 + 7 * x2 >= 0)
m.addConstr(2 * x1 - 6 * x3 >= 0)
m.addConstr(13 * x0 + 13 * x1 <= 157)
m.addConstr(13 * x0 + 8 * x3 <= 157)
m.addConstr(13 * x0 + 9 * x2 <= 157)
m.addConstr(13 * x0 + 13 * x1 + 8 * x3 <= 157)
m.addConstr(13 * x0 + 13 * x1 + 9 * x2 <= 157)
m.addConstr(13 * x1 + 9 * x2 + 8 * x3 <= 157)
m.addConstr(10 * x0 + 5 * x2 <= 111)
m.addConstr(5 * x2 + 4 * x3 <= 124)
m.addConstr(10 * x0 + 4 * x3 <= 63)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B5: {x0.varValue}")
    print(f"Milligrams of vitamin C: {x1.varValue}")
    print(f"Milligrams of vitamin A: {x2.varValue}")
    print(f"Milligrams of vitamin D: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
