
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank_hours = m.addVar(lb=0, type=gp.GRB.CONTINUOUS, name="hank_hours")
ringo_hours = m.addVar(lb=0, type=gp.GRB.INTEGER, name="ringo_hours")
jean_hours = m.addVar(lb=0, type=gp.GRB.CONTINUOUS, name="jean_hours")
mary_hours = m.addVar(lb=0, type=gp.GRB.INTEGER, name="mary_hours")

# Set objective function
m.setObjective(9.17 * hank_hours + 1.52 * ringo_hours + 4.32 * jean_hours + 7.39 * mary_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * hank_hours + 7 * jean_hours >= 14)
m.addConstr(7 * ringo_hours + 7 * jean_hours >= 11)
m.addConstr(11 * hank_hours + 7 * ringo_hours + 3 * mary_hours >= 15)
m.addConstr(9 * hank_hours + 3 * ringo_hours >= 26)
m.addConstr(9 * hank_hours + 6 * jean_hours >= 14)
m.addConstr(2 * jean_hours + 7 * mary_hours >= 56)
m.addConstr(2 * jean_hours + 5 * mary_hours <= 28)
m.addConstr(9 * hank_hours + 2 * jean_hours <= 63)
m.addConstr(4 * ringo_hours + 5 * mary_hours <= 79)
m.addConstr(9 * hank_hours + 4 * ringo_hours <= 63)
m.addConstr(9 * hank_hours + 4 * ringo_hours + 2 * jean_hours + 5 * mary_hours <= 63)
m.addConstr(7 * jean_hours + 3 * mary_hours <= 16)
m.addConstr(11 * hank_hours + 7 * ringo_hours <= 25)
m.addConstr(11 * hank_hours + 7 * ringo_hours + 7 * jean_hours + 3 * mary_hours <= 25)
m.addConstr(6 * jean_hours + 10 * mary_hours <= 44)
m.addConstr(9 * hank_hours + 10 * mary_hours <= 102)
m.addConstr(9 * hank_hours + 6 * jean_hours <= 100)
m.addConstr(9 * hank_hours + 3 * ringo_hours + 6 * jean_hours + 10 * mary_hours <= 100)
m.addConstr(2 * hank_hours + 7 * mary_hours <= 115)
m.addConstr(2 * jean_hours + 7 * mary_hours <= 75)
m.addConstr(4 * ringo_hours + 2 * jean_hours <= 84)
m.addConstr(2 * hank_hours + 2 * jean_hours <= 111)
m.addConstr(4 * ringo_hours + 7 * mary_hours <= 105)
m.addConstr(2 * hank_hours + 4 * ringo_hours + 2 * jean_hours + 7 * mary_hours <= 105)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

