
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=0, name="x0")  # hours worked by Hank
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1")  # hours worked by Ringo
x2 = m.addVar(lb=0, name="x2")  # hours worked by Jean
x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x3")  # hours worked by Mary

# Define the objective function
m.setObjective(9.17*x0 + 1.52*x1 + 4.32*x2 + 7.39*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x0 + 7*x2 >= 14)  
m.addConstr(7*x1 + 7*x2 >= 11)  
m.addConstr(11*x0 + 7*x1 + 3*x3 >= 15)  
m.addConstr(9*x0 + 3*x1 >= 26)  
m.addConstr(9*x0 + 6*x2 >= 14)  
m.addConstr(2*x2 + 7*x3 >= 56)  
m.addConstr(2*x2 + 5*x3 <= 28)  
m.addConstr(9*x0 + 2*x2 <= 63)  
m.addConstr(4*x1 + 5*x3 <= 79)  
m.addConstr(9*x0 + 4*x1 <= 63)  
m.addConstr(9*x0 + 4*x1 + 2*x2 + 5*x3 <= 63)  
m.addConstr(7*x2 + 3*x3 <= 16)  
m.addConstr(11*x0 + 7*x1 <= 25)  
m.addConstr(11*x0 + 7*x1 + 7*x2 + 3*x3 <= 25)  
m.addConstr(6*x2 + 10*x3 <= 44)  
m.addConstr(9*x0 + 10*x3 <= 102)  
m.addConstr(9*x0 + 6*x2 <= 100)  
m.addConstr(9*x0 + 3*x1 + 6*x2 + 10*x3 <= 100)  
m.addConstr(2*x0 + 7*x3 <= 115)  
m.addConstr(2*x2 + 7*x3 <= 75)  
m.addConstr(4*x1 + 2*x2 <= 84)  
m.addConstr(2*x0 + 2*x2 <= 111)  
m.addConstr(4*x1 + 7*x3 <= 105)  
m.addConstr(2*x0 + 4*x1 + 2*x2 + 7*x3 <= 105)  

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Hank: ", x0.varValue)
    print("Hours worked by Ringo: ", x1.varValue)
    print("Hours worked by Jean: ", x2.varValue)
    print("Hours worked by Mary: ", x3.varValue)
else:
    print("The problem is infeasible")
