
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_iron_optimization")

    # Create variables
    vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
    iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")


    # Set objective function
    m.setObjective(1 * vitamin_d + 8 * iron, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(17 * vitamin_d + 1 * iron >= 48, "kidney_support_min")
    m.addConstr(-9 * vitamin_d + 1 * iron >= 0, "vitamin_iron_ratio")
    m.addConstr(17 * vitamin_d + 1 * iron == 74, "kidney_support_exact") # Combined the <= and = constraints


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"Milligrams of Vitamin D: {vitamin_d.x}")
        print(f"Milligrams of Iron: {iron.x}")
        print(f"Objective Value: {m.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
