
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_D")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_iron")

# Set objective function
m.setObjective(x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x1 + x2 >= 48, name="kidney_support_index_minimum")
m.addConstr(17*x1 + x2 <= 74, name="kidney_support_index_maximum")
m.addConstr(-9*x1 + x2 >= 0, name="linear_combination_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin D: {x1.x}")
    print(f"Milligrams of Iron: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
