
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin D
    x2 = model.addVar(name="x2", lb=0)  # milligrams of iron

    # Define the objective function
    model.setObjective(x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(17 * x1 + x2 >= 48)
    model.addConstr(-9 * x1 + x2 >= 0)
    model.addConstr(17 * x1 + x2 <= 74)

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x1.varValue}")
        print(f"Milligrams of iron: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
