
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
peggy = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy")


# Set objective function
model.setObjective(3 * ringo + 5 * jean + 8 * hank + 9 * peggy, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10 * jean + 6 * peggy >= 51)
model.addConstr(15 * ringo + 10 * jean + 4 * hank >= 58)
model.addConstr(15 * ringo + 10 * jean + 6 * peggy >= 58)
model.addConstr(10 * jean + 4 * hank + 6 * peggy >= 58)
model.addConstr(15 * ringo + 10 * jean + 4 * hank >= 69)
model.addConstr(15 * ringo + 10 * jean + 6 * peggy >= 69)
model.addConstr(10 * jean + 4 * hank + 6 * peggy >= 69)
model.addConstr(15 * ringo + 10 * jean + 4 * hank >= 57)
model.addConstr(15 * ringo + 10 * jean + 6 * peggy >= 57)
model.addConstr(10 * jean + 4 * hank + 6 * peggy >= 57)
model.addConstr(17 * jean + 13 * peggy >= 62)
model.addConstr(1 * hank + 13 * peggy >= 59)
model.addConstr(17 * jean + 1 * hank >= 80)
model.addConstr(6 * ringo + 17 * jean + 13 * peggy >= 77)
model.addConstr(17 * jean + 1 * hank + 13 * peggy >= 77)
model.addConstr(6 * ringo + 17 * jean + 13 * peggy >= 59)
model.addConstr(17 * jean + 1 * hank + 13 * peggy >= 59)
model.addConstr(6 * jean + 9 * hank - 9 * peggy >= 0)
model.addConstr(10 * jean + 4 * hank <= 165)
model.addConstr(15 * ringo + 10 * jean <= 445)
model.addConstr(15 * ringo + 4 * hank <= 380)
model.addConstr(10 * jean + 6 * peggy <= 153)
model.addConstr(15 * ringo + 6 * peggy <= 120)
model.addConstr(4 * hank + 6 * peggy <= 258)
model.addConstr(15 * ringo + 10 * jean + 4 * hank + 6 * peggy <= 258)
model.addConstr(6 * ringo + 17 * jean <= 243)
model.addConstr(6 * ringo + 13 * peggy <= 220)
model.addConstr(17 * jean + 13 * peggy <= 112)
model.addConstr(1 * hank + 13 * peggy <= 201)
model.addConstr(6 * ringo + 17 * jean + 13 * peggy <= 159)
model.addConstr(17 * jean + 1 * hank + 13 * peggy <= 303)
model.addConstr(6 * ringo + 17 * jean + 1 * hank + 13 * peggy <= 303)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print("Variable values:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

