
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
    vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
    vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")


    # Set objective function
    m.setObjective(3.78 * magnesium + 8.9 * vitamin_b1 + 5.8 * vitamin_k, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(13 * magnesium + 6 * vitamin_k >= 36, "c0")
    m.addConstr(13 * magnesium + 4 * vitamin_b1 >= 22, "c1")
    m.addConstr(13 * magnesium + 4 * vitamin_b1 + 6 * vitamin_k >= 53, "c2")
    m.addConstr(6 * magnesium - 2 * vitamin_b1 >= 0, "c3")
    m.addConstr(3 * vitamin_b1 - 9 * vitamin_k >= 0, "c4")
    m.addConstr(13 * magnesium + 4 * vitamin_b1 <= 89, "c5")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('magnesium: %g' % magnesium.x)
        print('vitamin_b1: %g' % vitamin_b1.x)
        print('vitamin_k: %g' % vitamin_k.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
