
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, name="milligrams_of_magnesium")
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_B1")
x3 = m.addVar(lb=0, name="milligrams_of_vitamin_K")

# Define the objective function
m.setObjective(3.78*x1 + 8.9*x2 + 5.8*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(13*x1 + 6*x3 >= 36, name="constraint_1")
m.addConstr(13*x1 + 4*x2 >= 22, name="constraint_2")
m.addConstr(13*x1 + 4*x2 + 6*x3 >= 53, name="constraint_3")
m.addConstr(6*x1 - 2*x2 >= 0, name="constraint_4")
m.addConstr(3*x2 - 9*x3 >= 0, name="constraint_5")
m.addConstr(13*x1 + 4*x2 <= 89, name="constraint_6")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of magnesium: {x1.x}")
    print(f"Milligrams of vitamin B1: {x2.x}")
    print(f"Milligrams of vitamin K: {x3.x}")
else:
    print("No optimal solution found")
